REM Get the most recent input files from localsdp
net use L: \\localsdp\root\_Packages\Global\SAP-IT\sappcadm\files
copy L:\*.ini "D:\Program Files\generateConfig\in\"
copy L:\*.unx "D:\Program Files\generateConfig\in\"

REM Make sure all required input files exist
if not exist "D:\Program Files\generateConfig\in\sapmsg.ini" ( 
	echo ERROR: Input file "sapmsg.ini" is missing!
	goto end
)
if not exist "D:\Program Files\generateConfig\in\saproute.ini" (
	echo ERROR: Input file "saproute.ini" is missing!
	goto end
)
if not exist "D:\Program Files\generateConfig\in\services.unx" (
	echo ERROR: Input file "services.unx" is missing!
	goto end
)

REM Convert the files
D:
cd "D:\Program Files\generateConfig"
perl generateMessageServers.pl -m in\sapmsg.ini -s in\services.unx -j out\messageservers.txt -d out\systemdesc.txt -o
perl generateRouters.pl -w in\saproute.ini -j out\routers.txt -o

REM Put the generated files on the webserver
move "D:\inetpub\wwwjavagui\config\*.txt" "D:\inetpub\wwwjavagui\config\saveold\"
copy out\*.* "D:\inetpub\wwwjavagui\config\"

REM Clean up
del /Q "D:\Program Files\generateConfig\in\*.*"
del /Q "D:\Program Files\generateConfig\out\*.*"
net use L: /DELETE

:end
